/* 
 * limit-fsize.c 
 *
 * Зменшує обмеження на розмір файлу і намагається записати у файл більше
 * даних, ніж дозволено.
 * Ілюструє порядок застосування функцій getrlimit(), setrlimit().
 *
 */

#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/resource.h>
#include <unistd.h>


int main(void)
{
        struct rlimit r;
        char *filename = "tmpfile";
        int fd;
        enum { BUFSIZE = 500 };
        char buf[BUFSIZE] = { 0 };

        /* Отримує діюче обмеження на розмір файлу. */
        if (getrlimit(RLIMIT_FSIZE, &r) != 0) {
                fprintf(stderr, "Error getting limit for RLIMIT_FSIZE:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Зменшує обмеження на розмір файлу до 500 байтів. */
        r.rlim_cur = BUFSIZE;
        if (setrlimit(RLIMIT_FSIZE, &r) != 0) {
                fprintf(stderr, "Error setting limit for RLIMIT_FSIZE:"
                                                " %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Відкриває файл на запис (і при цьому створює його
           або обнуляє). */
        fd = open(filename, O_WRONLY | O_CREAT | O_TRUNC, 00660);
        if (fd < 0) {
                fprintf(stderr, "Error opening file %s: %s\n",
                                        filename, strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Намагається записати в файл удвічі більше байтів,
           ніж дозволено. */
        if ((write(fd, buf, sizeof(buf)) < 0)
                || (write(fd, buf, sizeof(buf)) < 0)) {
                fprintf(stderr, "Error writing to file %s: %s\n",
                                                filename, strerror(errno));
                exit(EXIT_FAILURE);
        }

        printf("Wrote two buffers! (?)\n");
        exit(EXIT_SUCCESS);
}
